/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.rewards;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import questsadditions.rewards.Repeatable;
import questsadditions.rewards.RewardsRegistry;

public class RepeatableReward
extends RandomReward
implements Repeatable {
    public RewardTable table;

    public RepeatableReward(Quest quest) {
        super(quest);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        return this.getTable() == null || this.getTable().rewards.isEmpty() ? Icons.REFRESH : this.getTable().getIcon();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list) {
        if (this.getTable() != null) {
            this.getTable().addMouseOverText(list, false, false);
        }
    }

    public void claim(ServerPlayer player, boolean notify) {
        RewardTable table = this.getTable();
        if (table == null) {
            return;
        }
        ProgressChange progressChange = new ProgressChange((QuestFile)ServerQuestFile.INSTANCE);
        progressChange.origin = this.quest;
        progressChange.player = player.m_142081_();
        TeamData teamData = ServerQuestFile.INSTANCE.getData((Entity)player);
        teamData.setStarted(this.quest.id, null);
        teamData.setCompleted(this.quest.id, null);
        for (QuestObject child : this.quest.getChildren()) {
            child.forceProgress(teamData, progressChange);
        }
        this.claim(table, player);
        this.forceProgress(teamData, progressChange);
    }

    protected void claim(RewardTable table, ServerPlayer player) {
        for (WeightedReward reward : table.rewards) {
            reward.reward.claim(player, false);
        }
    }

    public RewardType getType() {
        return RewardsRegistry.REPEAT;
    }
}

